/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public abstract class WallScatterFeature<FC extends ScatterFeatureConfig>
extends Feature<FC> {
    private static final Direction[] DIR = BlocksHelper.makeHorizontal();

    public WallScatterFeature(Codec<FC> codec) {
        super(codec);
    }

    public abstract boolean canGenerate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, Direction var5);

    public abstract void generate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, Direction var5);

    public boolean m_142674_(FeaturePlaceContext<FC> featureConfig) {
        ScatterFeatureConfig cfg = (ScatterFeatureConfig)featureConfig.m_159778_();
        RandomSource random = featureConfig.m_225041_();
        BlockPos center = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        int maxY = world.m_6924_(Heightmap.Types.WORLD_SURFACE, center.m_123341_(), center.m_123343_());
        int minY = BlocksHelper.upRay((LevelAccessor)world, (BlockPos)new BlockPos(center.m_123341_(), 0, center.m_123343_()), (int)maxY);
        if (maxY < 10 || maxY < minY) {
            return false;
        }
        int py = MHelper.randRange((int)minY, (int)maxY, (RandomSource)random);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (int x = -cfg.radius; x <= cfg.radius; ++x) {
            mut.m_142451_(center.m_123341_() + x);
            for (int y = -cfg.radius; y <= cfg.radius; ++y) {
                mut.m_142448_(py + y);
                block2: for (int z = -cfg.radius; z <= cfg.radius; ++z) {
                    mut.m_142443_(center.m_123343_() + z);
                    if (random.m_188503_(4) != 0 || !world.m_46859_((BlockPos)mut)) continue;
                    this.shuffle(random);
                    for (Direction dir : DIR) {
                        if (!this.canGenerate(cfg, world, random, (BlockPos)mut, dir)) continue;
                        this.generate(cfg, world, random, (BlockPos)mut, dir);
                        continue block2;
                    }
                }
            }
        }
        return true;
    }

    private void shuffle(RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            int j = random.m_188503_(4);
            Direction d = DIR[i];
            WallScatterFeature.DIR[i] = DIR[j];
            WallScatterFeature.DIR[j] = d;
        }
    }
}

